// VERSION: Scilab: 5.4.1 
// OS: windows 7

//CAPTION: EVEN and ODD SIGNALS for x(t)=sint(t)+cos(t)

clc;
close;
clear all;
t=0:.005:4*%pi;
x=sin(t)+cos(t); // Given signal: x(t)=sint(t)+cos(t)
subplot(2,2,1)
plot(t,x)
xlabel('t');
ylabel('amplitude')
title('input signal')
y=sin(-t)+cos(-t) // Put t = -t in x(t)
subplot(2,2,2)
plot(t,y)
xlabel('t');
ylabel('amplitude')
title('x(-t)')
z=x+y
subplot(2,2,3)
plot(t,z/2)  // to plot even signal
xlabel('t');
ylabel('amplitude')
title('even part of the signal')
p=x-y
subplot(2,2,4)
plot(t,p/2) // to plot odds signal
xlabel('t');
ylabel('amplitude');
title('odd part of the signal');

//Output: In graphic window
